/* - MCCurrentChangeListener - 
 * Display the data from a current change event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.CurrentChangeEvent;

import javax.swing.JTextField;
import javax.swing.JComboBox;

public class MCCurrentChangeListener implements CurrentChangeListener {

    private JComboBox motorCmb;
    private JTextField currentTxt;

    /** Creates a new instance of MCCurrentChangeListener */
    public MCCurrentChangeListener(JTextField currentTxt, JComboBox motorCmb) {
        this.motorCmb = motorCmb;
        this.currentTxt = currentTxt;
    }

    public void currentChanged(CurrentChangeEvent currentChangeEvent) {
        if (currentChangeEvent.getIndex() == ((Integer) motorCmb.getSelectedItem()).intValue()) {
            currentTxt.setText(Double.toString(currentChangeEvent.getValue()));
        }
    }
}
